#version 330 core

uniform mat4 ModelViewProjectionMatrix;
uniform mat4 ModelViewMatrix;
//uniform mat4 ProjectionMatrix;
//uniform mat4 TextureMatrix;

in vec4 POSITION;

//out vec2 uv;
out vec3 wpos;
out float intensity;

void main()
{

	float k = clamp(POSITION.w, 0.0, 1.0);
	intensity = smoothstep(0.1, 0.7, k);

	wpos = vec3(ModelViewMatrix * vec4(POSITION.xyz, 1.0));

	gl_PointSize = 6.0 + 12.0*smoothstep(0.2, 0.8, 1.0 - k);
	//gl_PointSize = 16.0 - 4.0*smoothstep(0.2, 0.8, 1.0 - k);
	//gl_PointSize = 8.0*k;

	gl_Position = ModelViewProjectionMatrix * vec4(POSITION.xyz, 1.0);
}

